<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<!-- Modern Biodata Section -->
<div class="biodata-section" style="
    min-height: 100vh; 
    background: linear-gradient(135deg, #F0F8FF 0%, #E6F3FF 50%, #DBEAFE 100%);
    padding: 100px 0 50px 0;
">
    <div class="container">
        <!-- Page Header -->
        <div class="page-header text-center mb-5">
            <h1 class="page-title" style="
                color: #1E3A8A; 
                font-size: 3rem; 
                font-weight: 700; 
                margin-bottom: 1rem;
                background: linear-gradient(135deg, #1E3A8A 0%, #4169E1 50%, #87CEEB 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            ">
                <i class="bi bi-person-badge me-3" style="color: #4169E1;"></i>
                Professional Profile
            </h1>
            <p style="color: #1E3A8A; font-size: 1.2rem;">Complete biodata and professional information</p>
        </div>

        <!-- Biodata Content -->
        <?php if (empty($biodata)): ?>
            <div class="alert-card text-center" style="
                background: rgba(255, 255, 255, 0.9); 
                border: 1px solid rgba(135, 206, 235, 0.3); 
                border-radius: 20px; 
                padding: 3rem;
                box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
            ">
                <i class="bi bi-info-circle" style="font-size: 4rem; color: #4169E1; margin-bottom: 1rem;"></i>
                <h3 style="color: #1E3A8A; margin-bottom: 1rem;">Biodata Not Available</h3>
                <p style="color: #1E3A8A;">Professional profile information is not yet available.</p>
            </div>
        <?php else: ?>
            <div class="biodata-container">
                <div class="row g-4">
                    <!-- Profile Image Section -->
                    <div class="col-lg-4">
                        <div class="profile-card" style="
                            background: rgba(255, 255, 255, 0.95); 
                            border: 1px solid rgba(135, 206, 235, 0.3); 
                            border-radius: 24px; 
                            padding: 2rem;
                            box-shadow: 0 12px 35px rgba(65, 105, 225, 0.15);
                            text-align: center;
                            height: fit-content;
                            position: sticky;
                            top: 120px;
                        ">
                            <!-- Profile Image -->
                            <div class="profile-image-section mb-4">
                                <?php if ($biodata['foto_profil']): ?>
                                    <div class="profile-wrapper position-relative d-inline-block">
                                        <?= clickable_image('biodata', $biodata['foto_profil'], esc($biodata['nama_lengkap']), 'profile-img-modern', 250, 250) ?>
                                        <div class="profile-status" style="
                                            position: absolute; 
                                            bottom: 10px; 
                                            right: 10px; 
                                            background: linear-gradient(135deg, #87CEEB, #4169E1); 
                                            color: white; 
                                            padding: 6px 12px; 
                                            border-radius: 20px; 
                                            font-size: 0.8rem; 
                                            font-weight: 600;
                                        ">
                                            <i class="bi bi-circle-fill me-1" style="font-size: 0.5rem; color: #90EE90;"></i>
                                            Active
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="profile-placeholder" style="
                                        width: 250px; 
                                        height: 250px; 
                                        background: linear-gradient(135deg, #87CEEB, #4169E1); 
                                        border-radius: 50%; 
                                        display: flex; 
                                        align-items: center; 
                                        justify-content: center;
                                        margin: 0 auto;
                                    ">
                                        <i class="bi bi-person" style="font-size: 6rem; color: white;"></i>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Name and Title -->
                            <h2 style="color: #1E3A8A; font-weight: 700; margin-bottom: 0.5rem;">
                                <?= esc($biodata['nama_lengkap']) ?>
                            </h2>
                            <?php if ($biodata['nama_panggilan']): ?>
                                <p style="color: #4169E1; font-size: 1.1rem; font-style: italic; margin-bottom: 1.5rem;">
                                    "<?= esc($biodata['nama_panggilan']) ?>"
                                </p>
                            <?php endif; ?>

                            <!-- Social Media Links -->
                            <?php if ($biodata['linkedin'] || $biodata['github'] || $biodata['instagram'] || $biodata['website']): ?>
                                <div class="social-links-modern d-flex justify-content-center gap-3 mb-3">
                                    <?php if ($biodata['linkedin']): ?>
                                        <a href="<?= esc($biodata['linkedin']) ?>" target="_blank" class="social-btn" title="LinkedIn">
                                            <i class="bi bi-linkedin"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($biodata['github']): ?>
                                        <a href="<?= esc($biodata['github']) ?>" target="_blank" class="social-btn" title="GitHub">
                                            <i class="bi bi-github"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($biodata['instagram']): ?>
                                        <a href="<?= esc($biodata['instagram']) ?>" target="_blank" class="social-btn" title="Instagram">
                                            <i class="bi bi-instagram"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if ($biodata['website']): ?>
                                        <a href="<?= esc($biodata['website']) ?>" target="_blank" class="social-btn" title="Website">
                                            <i class="bi bi-globe"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Information Section -->
                    <div class="col-lg-8">
                        <div class="info-sections">
                            <!-- Contact Information -->
                            <div class="info-card mb-4" style="
                                background: rgba(255, 255, 255, 0.95); 
                                border: 1px solid rgba(135, 206, 235, 0.3); 
                                border-radius: 20px; 
                                padding: 2rem;
                                box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                            ">
                                <h3 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1.5rem;">
                                    <i class="bi bi-person-lines-fill me-2" style="color: #4169E1;"></i>
                                    Informasi Kontak
                                </h3>
                                
                                <div class="row g-3">
                                    <?php if ($biodata['email']): ?>
                                        <div class="col-md-6">
                                            <div class="contact-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 1rem;
                                                border-left: 4px solid #4169E1;
                                            ">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-envelope-fill me-3" style="color: #4169E1; font-size: 1.2rem;"></i>
                                                    <div>
                                                        <small style="color: #1E3A8A; opacity: 0.8;">Email</small>
                                                        <div>
                                                            <a href="mailto:<?= esc($biodata['email']) ?>" style="color: #1E3A8A; text-decoration: none; font-weight: 500;">
                                                                <?= esc($biodata['email']) ?>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($biodata['no_telepon']): ?>
                                        <div class="col-md-6">
                                            <div class="contact-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 1rem;
                                                border-left: 4px solid #87CEEB;
                                            ">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-telephone-fill me-3" style="color: #87CEEB; font-size: 1.2rem;"></i>
                                                    <div>
                                                        <small style="color: #1E3A8A; opacity: 0.8;">Telepon</small>
                                                        <div style="color: #1E3A8A; font-weight: 500;">
                                                            <?= esc($biodata['no_telepon']) ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($biodata['alamat']): ?>
                                        <div class="col-12">
                                            <div class="contact-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 1rem;
                                                border-left: 4px solid #00BFFF;
                                            ">
                                                <div class="d-flex align-items-start">
                                                    <i class="bi bi-geo-alt-fill me-3" style="color: #00BFFF; font-size: 1.2rem; margin-top: 2px;"></i>
                                                    <div>
                                                        <small style="color: #1E3A8A; opacity: 0.8;">Alamat</small>
                                                        <div style="color: #1E3A8A; font-weight: 500; line-height: 1.5;">
                                                            <?= esc($biodata['alamat']) ?>
                                                            <?php if ($biodata['kota']): ?>
                                                                <br><?= esc($biodata['kota']) ?>
                                                            <?php endif; ?>
                                                            <?php if ($biodata['provinsi']): ?>
                                                                , <?= esc($biodata['provinsi']) ?>
                                                            <?php endif; ?>
                                                            <?php if ($biodata['kode_pos']): ?>
                                                                <?= esc($biodata['kode_pos']) ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($biodata['tempat_lahir'] || $biodata['tanggal_lahir']): ?>
                                        <div class="col-md-6">
                                            <div class="contact-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 1rem;
                                                border-left: 4px solid #FFB6C1;
                                            ">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-calendar-event-fill me-3" style="color: #FFB6C1; font-size: 1.2rem;"></i>
                                                    <div>
                                                        <small style="color: #1E3A8A; opacity: 0.8;">Birth</small>
                                                        <div style="color: #1E3A8A; font-weight: 500;">
                                                            <?php if ($biodata['tempat_lahir']): ?>
                                                                <?= esc($biodata['tempat_lahir']) ?>
                                                            <?php endif; ?>
                                                            <?php if ($biodata['tanggal_lahir']): ?>
                                                                <br><?= date('d F Y', strtotime($biodata['tanggal_lahir'])) ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($biodata['jenis_kelamin']): ?>
                                        <div class="col-md-6">
                                            <div class="contact-item" style="
                                                background: rgba(240, 248, 255, 0.8); 
                                                border-radius: 12px; 
                                                padding: 1rem;
                                                border-left: 4px solid #DDA0DD;
                                            ">
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-gender-ambiguous me-3" style="color: #DDA0DD; font-size: 1.2rem;"></i>
                                                    <div>
                                                        <small style="color: #1E3A8A; opacity: 0.8;">Gender</small>
                                                        <div style="color: #1E3A8A; font-weight: 500;">
                                                            <?= $biodata['jenis_kelamin'] === 'L' ? 'Male' : 'Female' ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- About Me Section -->
                            <?php if ($biodata['tentang_saya']): ?>
                                <div class="info-card mb-4" style="
                                    background: rgba(255, 255, 255, 0.95); 
                                    border: 1px solid rgba(135, 206, 235, 0.3); 
                                    border-radius: 20px; 
                                    padding: 2rem;
                                    box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                                ">
                                    <h3 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1.5rem;">
                                        <i class="bi bi-info-circle-fill me-2" style="color: #4169E1;"></i>
                                        Tentang Saya
                                    </h3>
                                    <div style="
                                        background: rgba(240, 248, 255, 0.6); 
                                        border-radius: 16px; 
                                        padding: 1.5rem;
                                        border-left: 4px solid #4169E1;
                                    ">
                                        <p style="color: #1E3A8A; line-height: 1.8; margin: 0; font-size: 1.1rem;">
                                            <?= nl2br(esc($biodata['tentang_saya'])) ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Skills Section -->
                            <?php if ($biodata['keahlian']): ?>
                                <div class="info-card" style="
                                    background: rgba(255, 255, 255, 0.95); 
                                    border: 1px solid rgba(135, 206, 235, 0.3); 
                                    border-radius: 20px; 
                                    padding: 2rem;
                                    box-shadow: 0 8px 25px rgba(65, 105, 225, 0.1);
                                ">
                                    <h3 style="color: #1E3A8A; font-weight: 600; margin-bottom: 1.5rem;">
                                        <i class="bi bi-tools me-2" style="color: #4169E1;"></i>
                                        Keahlian & Keahlian
                                    </h3>
                                    <div style="
                                        background: rgba(240, 248, 255, 0.6); 
                                        border-radius: 16px; 
                                        padding: 1.5rem;
                                        border-left: 4px solid #87CEEB;
                                    ">
                                        <p style="color: #1E3A8A; line-height: 1.8; margin: 0; font-size: 1.1rem;">
                                            <?= nl2br(esc($biodata['keahlian'])) ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Custom Styles -->
<style>
.profile-img-modern {
    width: 250px;
    height: 250px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid #FFFFFF;
    box-shadow: 0 12px 35px rgba(65, 105, 225, 0.3);
    transition: transform 0.3s ease;
    cursor: pointer;
}

.profile-img-modern:hover {
    transform: scale(1.05);
}

.social-btn {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    background: rgba(240, 248, 255, 0.8);
    border: 2px solid rgba(135, 206, 235, 0.3);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #4169E1;
    text-decoration: none;
    font-size: 1.2rem;
    transition: all 0.3s ease;
}

.social-btn:hover {
    background: #4169E1;
    color: white;
    border-color: #4169E1;
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(65, 105, 225, 0.3);
}

.contact-item {
    transition: all 0.3s ease;
}

.contact-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(65, 105, 225, 0.1);
}

.info-card {
    transition: all 0.3s ease;
}

.info-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(65, 105, 225, 0.2) !important;
}

/* Mobile Responsive */
@media (max-width: 991px) {
    .profile-card {
        position: static !important;
        margin-bottom: 2rem;
    }
    
    .profile-img-modern {
        width: 200px;
        height: 200px;
    }
    
    .page-title {
        font-size: 2.5rem !important;
    }
}

@media (max-width: 576px) {
    .profile-img-modern {
        width: 180px;
        height: 180px;
    }
    
    .info-card {
        padding: 1.5rem !important;
    }
    
    .contact-item {
        padding: 0.8rem !important;
    }
    
    .social-btn {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
}
</style>

<?= $this->endSection() ?>
